/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.web.*;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.deployment.WebBundleDescriptor;

/**
 * Tag class implements javax.servlet.jsp.tagext.JspTag for JSP version 2.0,
 * javax.servlet.jsp.tagext.Tag for earlier versions of JSP specification.
 *
 * @author sg133765
 */

public class TagClassExtendsValidInterface extends WebTest implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {

        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Context context = getVerifierContext();
        Result result = loadWarFile(descriptor);
        TagLibDescriptor tlds[] = context.getTagLibDescriptors();
        boolean failed=false;
        boolean oneFailed = false;

        if (tlds == null) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "No tag lib files are specified"));
            return result;

        }
        for(TagLibDescriptor tld : tlds) {
            TagDescriptor[] tagDesc = tld.getTagDescriptors();
            for(TagDescriptor td : tagDesc) {
                String tagclass = td.getTagClass();
                Class c = loadClass(result, tagclass);
                if (c!=null) {
                    if (tld.getSpecVersion().trim().equalsIgnoreCase("2.0")) {
                        failed = !javax.servlet.jsp.tagext.JspTag.class.isAssignableFrom(c);
                    } else {
                        failed = !javax.servlet.jsp.tagext.Tag.class.isAssignableFrom(c);
                    }
                    if(failed) {
                        oneFailed = true;
                        addErrorDetails(result, compName);
                        result.addErrorDetails(smh.getLocalString(getClass().getName() + ".failed",
                                "Error: tag class [ {0} ] in [ {1} ] does not implements valid interface",
                                new Object[] {c.getName(), tld.getUri()}));
                    } else {
                        addGoodDetails(result, compName);
                        result.addGoodDetails(smh.getLocalString
                                (getClass().getName() + ".passed1",
                                        "tag class [ {0} ] in [ {1} ] implements valid interface",
                                        new Object[] {c.getName(), tld.getUri()}));
                    }
                }
            }//for
        }
        if(oneFailed)
            result.setStatus(Result.FAILED);
        else
            result.setStatus(Result.PASSED);

        return result;
    }
}
