/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import java.util.Enumeration;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * Super class for all filter tests.
 * 
 * @author Jerome Dochez
 * @version 1.0
 */
public abstract class FilterClass extends WebTest implements WebCheck {

    /**
     * <p>
     * Run the verifier test against a declared individual filter class
     * </p>
     *
     * @param result is used to put the test results in
     * @param filterClass is the individual filter class object to test
     * @return true if the test pass
     */    
    abstract protected boolean runIndividualFilterTest(Result result, Class listenerClass);
    
    /** 
     * iterates over all declared filter in the archive file and 
     * delegates actual test on individual filter class to 
     * runIndividualFilterTest
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {
        
        Result result;
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
	if (filterEnum.hasMoreElements()) {
            boolean oneFailed = false;
	    // test the filters in this .war
            result = loadWarFile(descriptor);
	    while (filterEnum.hasMoreElements()) {
		ServletFilterDescriptor filter = (ServletFilterDescriptor) filterEnum.nextElement();
		Class filterClass = loadClass(result, filter.getClassName());
                                
                if (!runIndividualFilterTest(result, filterClass)) 
                    oneFailed=true;                
 	    }
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
            result = getInitializedResult();
            result.setStatus(Result.NOT_APPLICABLE);
	    result.addNaDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

	    result.notApplicable(smh.getLocalString
                ("com.sun.enterprise.tools.verifier.tests.web.FilterClass" + ".notApplicable",
		 "There are no filter components within the web archive [ {0} ]",
		 new Object[] {descriptor.getName()}));
	}

	return result;
    }
 }
