/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.util;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;

import java.util.*;
import java.io.File;

/**
 * This class is a helper around {@link ClosureCompiler}.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ArchiveClassesLoadableHelper {
    /**
     * This method is used to print the result in various
     * *ArchiveClassesLoadable tests.
     * @param cc a closure compiler which provides the necesasry information
     * @return a localized string which contains the details.
     */
    public static String getFailedResult(ClosureCompiler cc){
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Object o : cc.getFailed().entrySet()) {
            Map.Entry<String, List<String>> referencingPathToFailedList =
                    (Map.Entry<String, List<String>>)o;
            LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
            String classes = "Failed to find following classes:";
            if (smh != null) {
                classes = smh.getLocalString(
                        ArchiveClassesLoadableHelper.class.getName() + ".classes",
                        classes);
            }
            sb.append(classes).append("\n[");
            for (Iterator<String> iii = referencingPathToFailedList.getValue().iterator();
                 iii.hasNext();) {
                sb.append("\n\t").append(iii.next());
                if(iii.hasNext()) sb.append(",");
            }
            sb.append("\n]");
            String referencingPath = referencingPathToFailedList.getKey();
            if(referencingPath.length()==0) continue; // skip if a top level class is not found
            String ref = "referenced in the following call stack :\n";
            String reference = "at";
            if (smh != null) {
               ref = smh.getLocalString(
                        ArchiveClassesLoadableHelper.class.getName() + ".ref",
                        ref);
                reference = smh.getLocalString(
                        ArchiveClassesLoadableHelper.class.getName() + ".reference",
                        reference);
            }
            StringTokenizer st = new StringTokenizer(referencingPath, File.separator);
            Stack<String> referencingClassStack = new Stack<String>();
            while(st.hasMoreTokens()) {
                referencingClassStack.push(st.nextToken());
            }
            if(!referencingClassStack.isEmpty())
                 sb.append("\n\n"+ref);
            while(!referencingClassStack.isEmpty()){
                sb.append("\n\t").append(reference).append(" ");
                sb.append(referencingClassStack.pop());
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

