/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf.remotehomeintf;

import com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;

import java.lang.reflect.Method;

/** 
 * Enterprise beans home interface test.
 * 
 * The following are the requirements for the enterprise Bean's home interface 
 * signature: 
 * 
 * The methods defined in this interface must follow the rules for RMI-IIOP. 
 * This means that their arguments must be of valid types for RMI-IIOP
 * 
 */
public class RemoteHomeInterfaceRmiIIOPArgs extends HomeMethodTest { 
 /**
     * <p>
     * run an individual verifier test against a declared method of the 
     * local interface.
     * </p>
     * 
     * @param descriptor the deployment descriptor for the bean
     * @param method the method to run the test on
     */
 protected void runIndividualHomeMethodTest(Method method,EjbDescriptor descriptor, Result result) {
     
     Class[] methodParameterTypes = method.getParameterTypes();
     ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
     // The methods arguments types must be legal types for
     // RMI-IIOP.  This means that their arguments
     // must be of valid types for RMI-IIOP,
     if (RmiIIOPUtils.isValidRmiIIOPParameters(methodParameterTypes)) {
         // these method parameters are valid, continue
         addGoodDetails(result, compName);
         result.passed(smh.getLocalString
                 (getClass().getName() + ".passed",
                 "[ {0} ] properly declares method with valid RMI-IIOP parameter.",
                 new Object[] {method.getDeclaringClass().getName()}));
     } else {
         addErrorDetails(result, compName);
         result.failed(smh.getLocalString
                 (getClass().getName() + ".failed",
                 "Error: [ {0} ] method was found, but does not have valid RMI-IIOP " +
                 "method parameters.",
                 new Object[] {method.getName()}));
     }
 }

    protected String getHomeInterfaceName(EjbDescriptor descriptor) {
	return descriptor.getRemoteClassName();
    }
    
    protected String getInterfaceType() {
	return "remote";
    }

    protected String getSuperInterface() {
	return "javax.ejb.EJBHome";
    }
}
