/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.lang.reflect.Method;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Finder method implementation test
 * EJB 2.0 Spec 9.7.1 Entity bean class must not implement the ejbFind<METHOD>
 *
 * @author  Jerome Dochez
 * @version 
 */
public class FindMethodsAbstract extends QueryMethodTest {
    
    /**
     * <p>
     * Run an individual test against a finder method (single or multi)
     * </p>
     * 
     * @param method is the finder method reference
     * @param descriptor is the entity bean descriptor
     * @param targetClass is the class to apply to tests to
     * @param result is where to place the result
     * 
     * @return true if the test passes
     */    
    protected boolean runIndividualQueryTest(Method method, EjbCMPEntityDescriptor descriptor, Class targetClass, Result result) {
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();                
        // single or multi finder
        String methodName = method.getName();
        String ejbMethodName = "ejb" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        Method ejbMethod = getMethod(targetClass, methodName, method.getParameterTypes());
        if (ejbMethod != null) {
	    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
            result.addErrorDetails(smh.getLocalString
		("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.FindMethodsAbstract.failed",
                "Error : [ {0} ] is defined in bean class [ {1} ]",
		new Object[] {ejbMethodName , targetClass.getName()}));       
            return false;
        } else {
	    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
            result.addGoodDetails(smh.getLocalString
		("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.FindMethodsAbstract.passed",
                "[ {0} ] is not defined in bean class [ {1} ]",
		new Object[] {ejbMethodName , targetClass.getName()}));       
            return true;
        }
    }
}
