/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.*;


/** 
 * The reentrant element must be one of the following:
 *   True
 *   False
 */
public class ReEntrantElement extends EjbTest implements EjbCheck { 


    /** 
     * The reentrant element must be one of the following:
     *   True
     *   False
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	//  The reentrant element must be one of the following:
	//    True
	//    False

	if (descriptor instanceof EjbEntityDescriptor) {
	    boolean reentrant =
		((EjbEntityDescriptor)descriptor).isReentrant();
	    // this will never fail?
	    // need DOL to turn off checking and map XML elements to DOL 1-1
	    if ((reentrant == true) || (reentrant == false)) {
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));	
		result.passed
		    (smh.getLocalString
		     (getClass().getName() + ".passed",
		      "reEntrant [ {0} ] is valid within bean [ {1} ]",
		      new Object[] {new Boolean(reentrant),descriptor.getName()}));
	    } else {
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed
		    (smh.getLocalString
		     (getClass().getName() + ".failed",
		      "Error: reEntrant [ {0} ] is not valid within bean [ {1} ]",
		      new Object[] {new Boolean(reentrant),descriptor.getName()}));
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "{0} expected \n {1} bean, but called with {2} bean",
				  new Object[] {getClass(),"Entity","Session"}));
	}
	return result;
    }
}
