/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;

import java.util.Set;

/**
 * If the PostConstruct lifecycle callback interceptor method is the ejbCreate 
 * method, if the PreDestroy lifecycle callback interceptor method is the 
 * ejbRemove method, if the PostActivate lifecycle callback interceptor method 
 * is the ejbActivate method, or if the Pre-Passivate lifecycle callback 
 * interceptor method is the ejbPassivate method, these callback methods must 
 * be implemented on the bean class itself (or on its superclasses).
 * 
 * @author Vikas Awasthi
 */
public class CallbacksOnBeanClass extends EjbTest {

    Result result = null;
    ComponentNameConstructor compName = null;
    
    public Result check(EjbDescriptor descriptor) {
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();
        
        Set<EjbInterceptor> interceptors = descriptor.getInterceptorClasses();
        for (EjbInterceptor interceptor : interceptors) {
            if (interceptor.hasCallbackDescriptor(
                    LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE)) {
                Set<LifecycleCallbackDescriptor> callBackDescs = 
                        interceptor.getCallbackDescriptors(
                                LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE);
                reportError(callBackDescs, "ejbActivate",interceptor.getInterceptorClassName());
            }
            if (interceptor.hasCallbackDescriptor(
                    LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE)) {
                Set<LifecycleCallbackDescriptor> callBackDescs = 
                        interceptor.getCallbackDescriptors(
                                LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE);
                reportError(callBackDescs, "ejbPassivate",interceptor.getInterceptorClassName());
            }
            if (interceptor.hasCallbackDescriptor(
                    LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT)) {
                Set<LifecycleCallbackDescriptor> callBackDescs = 
                        interceptor.getCallbackDescriptors(
                                LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT);
                reportError(callBackDescs, "ejbCreate",interceptor.getInterceptorClassName());
            }
            if (interceptor.hasCallbackDescriptor(
                    LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY)) {
                Set<LifecycleCallbackDescriptor> callBackDescs = 
                        interceptor.getCallbackDescriptors(
                                LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY);
                reportError(callBackDescs, "ejbRemove",interceptor.getInterceptorClassName());
            }
        }
        
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName()+".passed",
                            "Valid lifecycle callback method(s)"));
        }
        return result;
    }
    
    private void reportError(Set<LifecycleCallbackDescriptor> callBackDescs, 
                             String callbackMethodName,
                             String interceptorClassName) {
        for (LifecycleCallbackDescriptor callbackDesc : callBackDescs) {
            String callbackMethod = callbackDesc.getLifecycleCallbackMethod();
            if(callbackMethod.contains(callbackMethodName)) {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                        (getClass().getName()+".failed",
                        "Wrong method [ {0} ] in class [ {1} ]",
                        new Object[] {callbackMethod, interceptorClassName}));
            }
        }
    }
}
