/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;


import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Enterprise Java Bean class exposed test.  
 * The class must not be exposed through remote or local interfaces.
 * @author Sheetal Vartak
 */
public class EjbClassExposed extends EjbTest { 

    Result result = null;
    ComponentNameConstructor compName = null;
    /**
     * Enterprise Java Bean class exposed test.  
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	result = getInitializedResult();
	compName = getVerifierContext().getComponentNameConstructor();

    if (descriptor instanceof EjbSessionDescriptor ||
            descriptor instanceof EjbEntityDescriptor) { 
        if (descriptor.getRemoteClassName() != null && 
                !((descriptor.getRemoteClassName()).equals(""))) 
            commonToBothInterfaces(descriptor.getRemoteClassName(),descriptor); 
        if (descriptor.getLocalClassName() != null && 
                !((descriptor.getLocalClassName()).equals(""))) 
            commonToBothInterfaces(descriptor.getLocalClassName(),descriptor); 
    }

    if(result.getStatus() != Result.FAILED) {
        addGoodDetails(result, compName);
        result.passed(smh.getLocalString(
                getClass().getName() + ".passed",
                "Ejb Bean Class [{0}] is valid.",
                new Object[] {descriptor.getEjbClassName()}));
    }
    return result;

    }

    /** 
     * This method is responsible for the logic of the test. It is called for 
     * both local and remote interfaces.
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @param remote for the Remote/Local interface of the Ejb. 
     */

    private void commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
	try { 
        Class c = Class.forName(remote, 
                                false, 
                                getVerifierContext().getClassLoader());

        for (Method method : c.getDeclaredMethods()) {
            String ejbClassName = descriptor.getEjbClassName();
            if(((method.getReturnType()).getName()).equals(ejbClassName)) {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString(
                        getClass().getName() + ".failed",
                        "Error: Ejb Bean Class [{0}] is exposed through interface [{1}]",
                        new Object[] {ejbClassName, remote}));
            }
        }
	}catch (ClassNotFoundException e) {
        addErrorDetails(result, compName);
	    result.failed(smh.getLocalString(
					     getClass().getName() + ".failedException",
					     "Error: interface class [{0}] not found",
					     new Object[] {remote}));
	}
    }
}
