/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * The EJB specification does not specify whether the ejb-jar file should 
 * include the classes that are in the ejb-client JAR by copy or by reference. 
 * If the by-copy approach is used, the producer simply includes all the class 
 * files in the ejb-client JAR file also in the ejb-jar file. If the 
 * by-reference approach is used, the ejb-jar file producer does not duplicate 
 * the content of the ejb-client JAR file in the ejb-jar file, but instead uses
 * a Manifest Class-Path entry in the ejb-jar file to specify that the ejb-jar 
 * file depends on the ejb-client JAR at runtime.
 */
public class EjbClientJarManifestClassPath extends EjbTest implements EjbCheck { 




    /** 
     * The EJB specification does not specify whether the ejb-jar file should 
     * include the classes that are in the ejb-client JAR by copy or by reference. 
     * If the by-copy approach is used, the producer simply includes all the class 
     * files in the ejb-client JAR file also in the ejb-jar file. If the 
     * by-reference approach is used, the ejb-jar file producer does not duplicate 
     * the content of the ejb-client JAR file in the ejb-jar file, but instead uses
     * a Manifest Class-Path entry in the ejb-jar file to specify that the ejb-jar 
     * file depends on the ejb-client JAR at runtime.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	// Stub test class placeholder
	// fill in guts/logic - pass/fail accordingly in future
	// once DOL returns proper value
	result.setStatus(Result.NOT_IMPLEMENTED);
	result.addNaDetails(smh.getLocalString
			    ("tests.componentNameConstructor",
			     "For [ {0} ]",
			     new Object[] {compName.toString()}));
	result.addNaDetails
	    (smh.getLocalString
	     (getClass().getName() + ".notImplemented",
	      "No static testing done - yet."));
	return result;

    }
}
