/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * CCITest.java
 *
 * Created on August 28, 2002
 */

package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.ClassLoader;
import java.util.Iterator;
import java.util.Set;
/**
 * Contains helper methods for all tests pertinent to CCI 
 *
 * @author Anisha Malhotra 
 * @version 
 */
public abstract class CCITest extends ConnectorTest {

  /**
   * <p>
   * Checks whether the resource adapater is implementing the CCI interfaces
   * </p>
   * @param descriptor the deployment descriptor
   * @param result to put the result
   * @return true if the CCI is implemented
   */
  protected boolean isCCIImplemented(ConnectorDescriptor descriptor, 
      Result result) {
    ComponentNameConstructor compName = 
      getVerifierContext().getComponentNameConstructor();
    OutboundResourceAdapter outboundRA =
      descriptor.getOutboundResourceAdapter();
    if(outboundRA == null)
    {
      return false;
    }
    Set connDefs = outboundRA.getConnectionDefs();
    Iterator iter = connDefs.iterator();
    while(iter.hasNext()) 
    {
      ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)
        iter.next();
      // check if intf implements javax.resource.cci.ConnectionFactory
      String intf = connDefDesc.getConnectionFactoryIntf();
      Class implClass = null;
      try
      {
        implClass = Class.forName(intf, false, getVerifierContext().getClassLoader());
      }
      catch(ClassNotFoundException e)
      {
      result.addErrorDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
        result.failed(smh.getLocalString
            ("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", 
             "The class [ {0} ] is not contained in the archive file",
             new Object[] {intf}));                
        continue;
      }
      if(isImplementorOf(implClass, "javax.resource.cci.ConnectionFactory"))
      {
        return true;
      }
    }
    return false;
  }


  /**
   * <p>
   * Returns the connection-interface that implements
   * "javax.resource.cci.Connection"
   * </p>
   * @param descriptor the deployment descriptor
   * @param result to put the result
   * @return interface name 
   */
  protected String getConnectionInterface(ConnectorDescriptor descriptor,
      Result result)
  {
    ComponentNameConstructor compName = 
      getVerifierContext().getComponentNameConstructor();
    OutboundResourceAdapter outboundRA =
      descriptor.getOutboundResourceAdapter();
    if(outboundRA == null)
    {
      return null;
    }
    Set connDefs = outboundRA.getConnectionDefs();
    Iterator iter = connDefs.iterator();
    while(iter.hasNext()) 
    {
      ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)
        iter.next();
      String intf = connDefDesc.getConnectionIntf();
      Context context = getVerifierContext();
      ClassLoader jcl = context.getRarClassLoader();
      Class intfClass = null;
      try
      {
        intfClass = Class.forName(intf, false, getVerifierContext().getClassLoader());    
      }
      catch(ClassNotFoundException e)
      {
        result.addErrorDetails(smh.getLocalString
            ("tests.componentNameConstructor",
             "For [ {0} ]",
             new Object[] {compName.toString()}));
        result.failed(smh.getLocalString
            ("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", 
             "The class [ {0} ] is not contained in the archive file",
             new Object[] {intf}));                
        continue;
      }
      if(isImplementorOf(intfClass, "javax.resource.cci.Connection"))
      {
        return intf;
      }
    }
    return null;
  }

}
