/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * TransactionSupport.java
 *
 * Created on September 20, 2000, 9:29 AM
 */

package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;

/**
 * Verify that the Transaction Support for the ressource adapter is of an 
 * acceptable value
 *
 * @author  Jerome Dochez
 * @version 
 */
public class TransactionSupport extends ConnectorTest implements ConnectorCheck {

    private final String[] acceptableValues = {
        ConnectorTagNames.DD_NO_TRANSACTION,
        ConnectorTagNames.DD_LOCAL_TRANSACTION,
        ConnectorTagNames.DD_XA_TRANSACTION };
                    
    /** 
     * <p>
     * Verifier test implementation. Check for the transaction-support 
     * deployment field which should be one of the acceptable values :
     *          NoTransaction
     *          LocalTransaction
     *          XATransaction
     * </p>
     *
     * @param <code>ConnectorDescritor</code>The deployment descriptor for
     * the connector.
     * @return <code>Result</code> Code execution result
     */
    public Result check(ConnectorDescriptor descriptor) {
        
        Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        if(!descriptor.getOutBoundDefined())
        {
          result.addNaDetails(smh.getLocalString
              ("tests.componentNameConstructor",
               "For [ {0} ]",
               new Object[] {compName.toString()}));
          result.notApplicable(smh.getLocalString
              ("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA",
               "Resource Adapter does not provide outbound communication"));
          return result;
        }
        String connectorTransactionSupport =
        descriptor.getOutboundResourceAdapter().getTransSupport();
        
        // No transaction support specified, this is an error
        if (connectorTransactionSupport==null) {
	    result.addErrorDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
	    result.failed(smh.getLocalString
			  (getClass().getName() + ".nonexist",
			   "Error: No Transaction support specified for ressource adapter",
			   new Object[] {connectorTransactionSupport}));        
            return result;
        }
        
        // let's loop over all acceptable values to check the declared one is valid
        for (int i=0;i<acceptableValues.length;i++) {
            if (connectorTransactionSupport.equals(acceptableValues[i])) {
                    
                // Test passed, we found an acceptable value
	       result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));	
		result.passed(smh.getLocalString
	            (getClass().getName() + ".passed",
                    "Transaction support [ {0} ] for ressource adapter is supported",
	            new Object[] {connectorTransactionSupport}));
               return result;
            }     
        }
        
        // If we end up here, we haven't found an acceptable transaction support
	result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	result.failed(smh.getLocalString
	       (getClass().getName() + ".failed",
                "Error: Deployment descriptor transaction-support [ {0} ] for ressource adapter is not valid",
		new Object[] {connectorTransactionSupport}));        
        return result;
    }
}
