/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceContextType;

/**
 * Assertion :
 *
 *  Only Stateful Session Bean can use EXTENDED persistence context type.
 *
 * @author bshankar@sun.com
 */
public abstract class AbstractPersistenceContextType extends VerifierTest
        implements VerifierCheck {
    final static String className = AbstractPersistenceContextType.class.getName();
    
    public Result check(Descriptor descriptor) {
        
        // initialize the result object
        Result result = getInitializedResult();
        addErrorDetails(result,
                getVerifierContext().getComponentNameConstructor());
        result.setStatus(Result.PASSED); //default status is PASSED
        
        if(!isStatefulSessionBean(descriptor)) {
            for (EntityManagerReferenceDescriptor emRefDesc : getEntityManagerReferenceDescriptors(descriptor)) {
                if(emRefDesc.getPersistenceContextType().equals(PersistenceContextType.EXTENDED)) {
                    String unitName = emRefDesc.getUnitName() == null ? "" : emRefDesc.getUnitName();
                    result.failed(
                            smh.getLocalString(className + ".failed", 
                            "Found a persistence unit by name [ {0} ] of EXTENDED context type.", new Object[]{unitName}));
                }
            }
        }
        return result;
    }
    
    protected abstract Collection<EntityManagerReferenceDescriptor>
            getEntityManagerReferenceDescriptors(Descriptor descriptor);
    
    protected abstract boolean isStatefulSessionBean(Descriptor d);
    
}