/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.ConditionalTagSupport;

import org.apache.taglibs.standard.examples.beans.Customer;

/**
 * <p>Tag handler for &lt;usCustomer&gt;
 *
 * @author Pierre Delisle
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:41 $
 */
public class UsCustomerTag extends ConditionalTagSupport {
    
    //*********************************************************************
    // Instance Variables
    
    /** Holds value of property customer. */
    private Customer customer;
    
    //*********************************************************************
    // Constructor and lusCustomerecycle management
    
    public UsCustomerTag() {
        super();
        init();
    }
    
    private void init() {
        customer = null;
    }
    
    //*********************************************************************
    // TagSupport methods
    
    public void release() {
        super.release();
        init();
    }
    
    //*********************************************************************
    // ConditionalTagSupport methods
    
    protected boolean condition() throws JspTagException {
        try {
            if (customer == null) {
                throw new NullAttributeException("usCustomer", "test");
            } else {
                //System.out.println("country: " + customer.getAddress().getCountry());
                return (customer.getAddress().getCountry().equalsIgnoreCase("USA"));
            }
        } catch (JspException ex) {
            throw new JspTagException(ex.toString());
        }
    }
    
    //*********************************************************************
    // Accessors
    
    /**
     * Getter for property customer.
     * @return Value of property customer.
     */
    public Customer getCustomer() {
        return customer;
    }
    
    /**
     * Setter for property customer.
     * @param customer New value of property customer.
     */
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }
}
