/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice.monitoring;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.XMLConstants;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
/**
 * This class is a name space resolver for the XPath expressions.
 *
 * @author Jerome Dochez
 */
public class NamespaceContextImpl implements NamespaceContext {
    
    /** Creates a new instance of NamespaceContextImpl */
    public NamespaceContextImpl(Document wsdlDoc) {
        // get all the namespaces declarations 
       NamedNodeMap attributes = wsdlDoc.getAttributes();
       if (attributes==null) 
           return;
       for (int i=0;i<attributes.getLength();i++) {
           Node attribute = attributes.item(i);
           System.out.println("attribute " + attribute.getNodeName() + " value " + attribute.getNodeValue());
       }
    }
    
    /**
     * <p>
     * Get Namespace URI bound to a prefix in the current scope
     * </p>
     * @param prefix to look up
     * @return Namespace URI
     */
    public String getNamespaceURI(String prefix) {
        if (prefix==null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if (XMLConstants.DEFAULT_NS_PREFIX.equals(prefix)) {
            return "http://schemas.xmlsoap.org/wsdl/";
        } 
        if (XMLConstants.XML_NS_PREFIX.equals(prefix)) {
            return XMLConstants.XML_NS_URI;
        } 
        if (XMLConstants.XMLNS_ATTRIBUTE.equals(prefix)) {
            return XMLConstants.XMLNS_ATTRIBUTE_NS_URI;
        }
        if ("soap".equals(prefix)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        if ("soap12".equals(prefix)) {
            return "http://schemas.xmlsoap.org/wsdl/soap12/";
        }        
        return XMLConstants.NULL_NS_URI;
    }
    
    /**
     * <p>
     * Get Prefix bound to Namespace URI in the current scope
     * </p>
     * @param URI of Namespace to look up
     * @return bound prefix
     */
    public String getPrefix(String namespace) {
        if (namespace==null) {
            throw new IllegalArgumentException("namespace is null");
        }
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            return XMLConstants.DEFAULT_NS_PREFIX;            
        } 
        if (XMLConstants.XML_NS_URI.equals(namespace)) {
            return XMLConstants.XML_NS_PREFIX;
        } 
        if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(namespace)) {
            return XMLConstants.XMLNS_ATTRIBUTE;
        }
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespace)) {
            return "soap";
        }
        if(("http://schemas.xmlsoap.org/wsdl/soap12/").equals(namespace)) {
            return "soap12";
        }        
        return null;        
    }
     
    /**
     * <p>
     * Get all prefixes bound to a Namespace URI in the current scope
     * </p>
     * @param Namespace URI to look up
     * @return Iterator on all the prefixes
     */
    public Iterator getPrefixes(String namespaceURI) {
        Vector v = new Vector();
        String prefix = getPrefix(namespaceURI);
        if (prefix!=null) {
            v.add(prefix);
        }
        return v.iterator();
    }
}
