/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import java.util.Hashtable;
import java.util.Iterator;

import java.lang.reflect.Proxy;
import java.lang.reflect.InvocationHandler;

import java.rmi.Remote;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import javax.xml.rpc.server.ServiceLifecycle;

import com.sun.enterprise.Switch;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;

// JAXRPC-RI classes
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.Implementor;
import com.sun.xml.rpc.spi.runtime.ImplementorCache;
import com.sun.xml.rpc.spi.runtime.ImplementorCacheDelegate;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.Tie;

/**
 * This class extends the behavior of ImplementorCache in order to
 * interpose on lifecycle events for the creation and destruction of 
 * ties/servants for servlet web service endpoints.
 *
 * @author Kenneth Saks
 */
public class ImplementorCacheDelegateImpl extends ImplementorCacheDelegate {

    private Hashtable implementorCache_;
    private ServletContext servletContext_;
    private JaxRpcObjectFactory rpcFactory_;

    public ImplementorCacheDelegateImpl(ServletConfig servletConfig) {
        servletContext_ = servletConfig.getServletContext();
        implementorCache_ = new Hashtable();
        rpcFactory_ = JaxRpcObjectFactory.newInstance();
    }

    public Implementor getImplementorFor(RuntimeEndpointInfo targetEndpoint) {

        Implementor implementor = null;
        try {
            synchronized(targetEndpoint) {
                implementor = (Implementor) 
                    implementorCache_.get(targetEndpoint);
                if( implementor == null ) {
                    implementor = createImplementor(targetEndpoint);
                    implementorCache_.put(targetEndpoint, implementor);
                }
            }

            InvocationManager invManager =
                Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            inv.setWebServiceTie(implementor.getTie());

        } catch(Throwable t) {
/* XXX FIXME
            JAXRPCServletException jse = new JAXRPCServletException
                ("error.implementorFactory.newInstanceFailed", 
                 targetEndpoint.getName());
            jse.initCause(t);
            throw jse;
*/
            RuntimeException re = new RuntimeException();
            re.initCause(t);
            throw re;
        }

        return implementor;
    }

    public void releaseImplementor(RuntimeEndpointInfo targetEndpoint, 
                                   Implementor implementor) {
        // do nothing
    }

    public void destroy() {
        for (Iterator iter = implementorCache_.values().iterator(); 
             iter.hasNext();) {
            Implementor implementor = (Implementor) iter.next();
            try {
                implementor.destroy();
            } catch(Throwable t) {
                // @@@ log
            }
        }
        implementorCache_.clear();
    }

    private Implementor createImplementor(RuntimeEndpointInfo targetEndpoint) 
        throws Exception {

        Tie tie = (Tie) targetEndpoint.getTieClass().newInstance();

        Class seiClass  = targetEndpoint.getRemoteInterface();
        Class implClass = targetEndpoint.getImplementationClass();

        Remote servant  = null;
        if( seiClass.isAssignableFrom(implClass) ) {
            // if servlet endpoint impl is a subtype of SEI, use an
            // instance as the servant.
            servant = (Remote) implClass.newInstance();
        } else {
            // Create a dynamic proxy that implements SEI (and optionally
            // ServiceLifecycle) and delegates to an instance of the 
            // endpoint impl.
            Object implInstance = implClass.newInstance();

            InvocationHandler handler = 
                new ServletImplInvocationHandler(implInstance);
            boolean implementsLifecycle = 
                ServiceLifecycle.class.isAssignableFrom(implClass);
            Class[] proxyInterfaces = implementsLifecycle ?
                new Class[] { seiClass, ServiceLifecycle.class } :
                new Class[] { seiClass };

            servant = (Remote) Proxy.newProxyInstance
                (implClass.getClassLoader(), proxyInterfaces, handler);
        }
        tie.setTarget(servant);
        
        Implementor implementor = rpcFactory_.createImplementor(servletContext_, tie);
        implementor.init();

        return implementor;
    }
}
