/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EjbServletWSSCallbackHandler.java
 *
 * Created on September 14, 2004, 12:56 PM
 */

package com.sun.enterprise.webservice;
import com.sun.enterprise.security.jauth.callback.*;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.*;
import javax.security.auth.callback.UnsupportedCallbackException;
import java.io.IOException;
import java.util.logging.*;
import com.sun.enterprise.security.wss.*;

/**
 * Callback Handler for Servlets/EJB
 * @author  Harpreet Singh
 */
public final class EjbServletWSSCallbackHandler extends WSSCallbackHandler{
    private static WSSCallbackHandler INSTANCE = null;
    
    /** Creates a new instance of EjbServletWSSCallbackHandler */
    private EjbServletWSSCallbackHandler() {
    }
    /**
     * returns a singleton instance of this class.
     */
    static WSSCallbackHandler newInstance() {
        if(INSTANCE == null){
            INSTANCE = new EjbServletWSSCallbackHandler();
        }
        return INSTANCE;
    }

    
    public void handle(Callback[] callbacks) 
        throws IOException, UnsupportedCallbackException 
    { 
        if(callbacks == null){
            return;
        }
        for (int i=0; i<callbacks.length; i++){
            if(!isSupportedCallback(callbacks[i])){
                _logger.log(Level.FINE, "wss-container-auth: UnsupportedCallback : "+
                    callbacks[i].getClass().getName());
                throw new UnsupportedCallbackException(callbacks[i]);
            }
            processCallback(callbacks[i]);
        }        
    }
    boolean isSupportedCallback(Callback callback) {
        boolean isSupported = false;
        if (callback instanceof CertStoreCallback){
            isSupported = true;
        } else if(callback instanceof PasswordValidationCallback){
            isSupported = true;
        } else if (callback instanceof SecretKeyCallback){
            isSupported = true;
        } else if (callback instanceof PrivateKeyCallback){
            isSupported = true;
        } else if (callback instanceof TrustStoreCallback){
            isSupported = true;
        } else{
            isSupported = false;
        }
        return isSupported;
    }

}
