/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.deploy;

import org.apache.catalina.deploy.SecurityCollection;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.web.WebModule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
/**
 * Decorator of class <code>org.apache.catalina.deploy.SecurityConstraint</code>
 *
 * @author Jean-Francois Arcand
 */
public class SecurityConstraintDecorator 
                    extends org.apache.catalina.deploy.SecurityConstraint {

    private SecurityConstraint securityConstraint;
    
    public SecurityConstraintDecorator(SecurityConstraint securityConstraint,
                                       WebModule webModule){
        this.securityConstraint = securityConstraint;
        
        if (securityConstraint.getAuthorizationConstraint() != null){
            setAuthConstraint(true);
            Enumeration enumeration = securityConstraint
                            .getAuthorizationConstraint().getSecurityRoles();

            SecurityRole securityRole;
            while (enumeration.hasMoreElements()){
                securityRole = (SecurityRole)enumeration.nextElement();
                super.addAuthRole(securityRole.getName());
                if ( !securityRole.getName().equals("*")){
                    webModule.addSecurityRole(securityRole.getName());
                }
            }
            setDisplayName(securityConstraint.getAuthorizationConstraint().getName());
        }
 
        if (securityConstraint.getUserDataConstraint() != null){
            setUserConstraint(securityConstraint.getUserDataConstraint()
                                                    .getTransportGuarantee());
        }
        
    }

}



