/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.deploy;

import org.apache.catalina.deploy.LoginConfig;


import org.apache.catalina.util.RequestUtil;
import java.io.Serializable;

import com.sun.enterprise.deployment.web.LoginConfiguration;

/**
 * Decorator of class <code>org.apache.catalina.deploy.LoginConfig</code>
 *
 * @author Jean-Francois Arcand
 */

public class LoginConfigDecorator extends LoginConfig {


    // ----------------------------------------------------------- Constructors

    private LoginConfiguration decoree;
    
    private String errorPage;
    
    private String loginPage;
    
    public LoginConfigDecorator(LoginConfiguration decoree){
        this.decoree = decoree;
        
        String errorPage = RequestUtil.URLDecode(decoree.getFormErrorPage());
        if (!errorPage.startsWith("/")){
            errorPage = "/" + errorPage;
        }
        setErrorPage(errorPage);
        
        String loginPage = RequestUtil.URLDecode(decoree.getFormLoginPage());
        if (!loginPage.startsWith("/")){
            loginPage = "/" + loginPage;
        }     
        setLoginPage(loginPage);
        setAuthMethod(decoree.getAuthenticationMethod());
        setRealmName(decoree.getRealmName());
    }


}
