/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PEWebContainerStartStopOperation.java
 *
 * Created on September 24, 2003, 3:47 PM
 * This class is a no-op implementation for stop instance operation
 * HERCULES:add
 */

package com.sun.enterprise.web;

import java.util.ArrayList;

/**
 *
 * @author lwhite
 */
public class PEWebContainerStartStopOperation implements WebContainerStartStopOperation {
    
    /**
     * The embedded Catalina object.
     */
    protected EmbeddedWebContainer _embedded = null;
    
    /** Creates a new instance of PEWebContainerStartStopOperation */
    public PEWebContainerStartStopOperation() {
    }    
    
    /** Creates a new instance of PEWebContainerStartStopOperation */
    public PEWebContainerStartStopOperation(EmbeddedWebContainer embedded) {
        _embedded = embedded;
    }    
    
    public void doPostStop(ArrayList list) {
        //deliberate no-op
    }
    
    public ArrayList doPreStop() {
        //deliberate no-op
        return null;
    }
    
    public void init(EmbeddedWebContainer embedded) {
        _embedded = embedded;
    }
    
}


