/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MemoryStrategyBuilder.java
 *
 * Created on September 30, 2002, 12:24 PM
 */

package com.sun.enterprise.web;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.ArrayList;
import org.apache.catalina.Context;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;
//import com.iplanet.ias.tools.common.dd.webapp.SessionManager;
//import com.sun.enterprise.tools.common.dd.webapp.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionManager;


public class MemoryStrategyBuilder extends BasePersistenceStrategyBuilder implements PersistenceStrategyBuilder{
    
    /** Creates a new instance of MemoryStrategyBuilder */
    /*
    public MemoryStrategyBuilder() {
    }*/
      
    
    public void initializePersistenceStrategy(Context ctx, SessionManager smBean) {
        super.initializePersistenceStrategy(ctx, smBean);
        String persistenceType = "memory";        
        String ctxPath = ctx.getPath();
        if(ctxPath != null && !ctxPath.equals("")) {    
            Object[] params = { ctx.getPath(), persistenceType };
            _logger.log(Level.FINE, "webcontainer.noPersistence", params); 
        }
        StandardManager mgr = new StandardManager();
        //remove this fix because we don't want unload persistence
        //unless sessionFilename has been set explicitly
        //following line replaces commented out code
        /*
        if (sessionFilename != null) {
            mgr.setPathname(sessionFilename);
        }
         */
        if (sessionFilename == null) {
            mgr.setPathname(sessionFilename);
        } else {
            mgr.setPathname(prependContextPathTo(sessionFilename, ctx));
        }
        StandardContext sctx = (StandardContext) ctx;
        sctx.restrictedSetPipeline(new WebPipeline(sctx));         
        
        mgr.setMaxActiveSessions(maxSessions);
        //START OF 6364900
        mgr.setSessionLocker(new PESessionLocker(ctx));
        //END OF 6364900        
        //FIXME: what is the replacement for setCheckInterval
        //mgr.setCheckInterval(reapInterval);
        ctx.setManager(mgr);
        
        //this must be after ctx.setManager(mgr);       
        if(!sctx.isSessionTimeoutOveridden()) {
           mgr.setMaxInactiveInterval(sessionMaxInactiveInterval); 
        }        
    }
    
}
