/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.util.*;
import java.io.*;
import com.sun.enterprise.repository.*;
import com.sun.enterprise.*;

//START OF IASRI 4660742
import java.util.logging.*;
import com.sun.logging.*;
//END OF IASRI 4660742


public class LegacyConfigConverter {

    // START OF IASRI 4660742
    static Logger _logger=LogDomains.getLogger(LogDomains.UTIL_LOGGER);
    // END OF IASRI 4660742

    private static final String OLD_JDBC_DRIVER_KEY = "jdbc.drivers";
    private static final String OLD_JDBC_DATASOURCES_KEY = "jdbc.datasources";
    private static final String OLD_JDBC_XA_DATASOURCES_KEY = 
        "jdbc20.datasources";
    private static final String OLD_JDBC_DELIMITER = "|";
    private static final String KEY_DELIMITER = ".";
    private static final String OLD_XA_DATASOURCE_PREFIX = "xadatasource";
    private static final String OLD_XA_JNDI_NAME = "jndiname";    
    private static final String OLD_XA_CLASSNAME = "classname";
    private static final String OLD_XA_DB_USER = "dbuser";
    private static final String OLD_XA_DB_PASSWORD = "dbpassword";
    private static final String OLD_PROP_INDICATOR = "prop";


    // START OF IASRI 4679641
    // private static final boolean debug = true;
    private static final boolean debug = com.sun.enterprise.util.logging.Debug.enabled;
    // END OF IASRI 4679641

    public static void main(String args[]) {
        if( args.length == 2 ) {
            String defaultPropsFilename = args[0];
            String destinationPropsFilename = args[1];
            LegacyConfigConverter conv = new LegacyConfigConverter();
	          /** IASRI 4660742
            System.out.println("Reading old jdbc properties from " +
                               defaultPropsFilename);
            System.out.println("Destination file is " + 
                               destinationPropsFilename);
	          **/
	          // START OF IASRI 4660742
            if (_logger.isLoggable(Level.FINE)) {
	              _logger.log(Level.FINE,"Reading old jdbc properties from " 
			                  + defaultPropsFilename);
	              _logger.log(Level.FINE,"Destination file is " 
			                  + destinationPropsFilename);
            }
	          // END OF IASRI 4660742
                              
            conv.convert(defaultPropsFilename, 
                         destinationPropsFilename);
            
        } else {
            System.out.println("Usage : <old_props_file> <new_props_file>");
            System.out.println("For example : " + "/a/b/default.properties "
                               + "/a/b/resource.properties");
        }
    }

    private J2EEResourceFactory resourceFactory_;

    public LegacyConfigConverter() {
    }

    public void convert(String oldFile, String newFile) {

        InputStream inputStream = null;

        try {
            File defaultPropsFile = new File(oldFile);
            FileInputStream fis = new FileInputStream(defaultPropsFile);
            inputStream = new BufferedInputStream(fis);
            Properties defaultProps = new Properties();
            defaultProps.load(inputStream);
            
            resourceFactory_ = ServerConfiguration.getJ2EEResourceFactory();

            J2EEResourceCollection resources =
                resourceFactory_.loadResourceCollection(newFile);

            // add jdbc stuff from default.properties 
            convertJdbcDrivers(defaultProps, resources);
            convertJdbcResources(defaultProps, resources);
            convertJdbcXAResources(defaultProps, resources);

            resourceFactory_.storeResourceCollection(resources, newFile);

	          /** IASRI 4660742
            System.out.println("Conversion complete.  " + oldFile + " has not been changed.  Please remove any obsolete jdbc properties if it will be used as a default.properties file in j2ee");
	          **/
	          // START OF IASRI 4660742
             if (_logger.isLoggable(Level.FINE)) {
	           _logger.log(Level.FINE,"Conversion complete.  " + oldFile + " has not been changed.  Please remove any obsolete jdbc properties if it will be used as a default.properties file in j2ee");
             }
	          // END OF IASRI 4660742

        } catch(Exception e) {
            /** IASRI 4660742
             e.printStackTrace(); 
            **/
	          // START OF IASRI 4660742
	          _logger.log(Level.SEVERE,"enterprise_util.excep_legacyconfigconverter_convert",e);
	          // END OF IASRI 4660742
            if( inputStream != null ) {
                try {
                    inputStream.close();
                } catch(Exception ce) {}
            }
        }
    }

    private void convertJdbcDrivers(Properties defaultProps,
                                     J2EEResourceCollection resources) 
        throws Exception {

        String drivers = defaultProps.getProperty(OLD_JDBC_DRIVER_KEY);

        if( drivers == null ) {
            /** IASRI 4660742
            System.out.println("No Jdbc Drivers..."); 
            **/
	          // START OF IASRI 4660742
	          _logger.log(Level.FINE,"No Jdbc Drivers...");
	          // END OF IASRI 4660742
            return;
        }

        StringTokenizer tokenizer = 
            new StringTokenizer(drivers, OLD_JDBC_DELIMITER);

        while(tokenizer.hasMoreTokens()) {
            String nextDriverClass = tokenizer.nextToken();
            J2EEResource driver = 
                resourceFactory_.createResource(J2EEResource.JDBC_DRIVER,
                                                nextDriverClass);
            resources.addResource(driver);
            if( debug ) {
                /** IASRI 4660742
                System.out.println("Adding " + driver); 
                **/
	    	        // START OF IASRI 4660742
                if (_logger.isLoggable(Level.FINE))
	    	            _logger.log(Level.FINE,"Adding " + driver);
	    	        // END OF IASRI 4660742
            }
        }
    }

    private void convertJdbcResources(Properties defaultProps,
                                      J2EEResourceCollection resources) 
        throws Exception {

        String jdbcResources = defaultProps.getProperty
            (OLD_JDBC_DATASOURCES_KEY);

        if( jdbcResources == null ) {
           /** IASRI 4660742
           System.out.println("No Jdbc Resources..."); 
           **/
	         // START OF IASRI 4660742
	         _logger.log(Level.FINE,"No Jdbc Resources...");
	         // END OF IASRI 4660742
            return;
        }

        StringTokenizer tokenizer = 
            new StringTokenizer(jdbcResources, OLD_JDBC_DELIMITER);

        while(tokenizer.hasMoreTokens()) {
            String jndiName = tokenizer.nextToken();
            String url = tokenizer.nextToken();

            JdbcResource jdbcResource = (JdbcResource)
                resourceFactory_.createResource(J2EEResource.JDBC_RESOURCE,
                                                jndiName);
            //jdbcResource.setUrl(url);
            resources.addResource(jdbcResource);
            if( debug ) {
                /** IASRI 4660742
                System.out.println("Adding " + jdbcResource); 
                **/
	   	          // START OF IASRI 4660742
                if (_logger.isLoggable(Level.FINE))
	   	              _logger.log(Level.FINE,"Adding " + jdbcResource);
	   	          // END OF IASRI 4660742
            }
        }
    }

    private void convertJdbcXAResources(Properties defaultProps,
                                        J2EEResourceCollection resources) 
        throws Exception {

        String xaResources = defaultProps.getProperty
            (OLD_JDBC_XA_DATASOURCES_KEY);

        if( xaResources == null ) {
           /** IASRI 4660742
           System.out.println("No XA Jdbc Resources..."); 
           **/
	         // START OF IASRI 4660742
	         _logger.log(Level.FINE,"No XA Jdbc Resources...");
	         // END OF IASRI 4660742
            return;
        }

        StringTokenizer tokenizer = 
            new StringTokenizer(xaResources, OLD_JDBC_DELIMITER);

        int xaDriverCount = 0;
        Hashtable xaDriverResources = new Hashtable();
        
        while(tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();

            String xaJndiName = tokenizer.nextToken();

            JdbcXAResource jdbcXAResource = (JdbcXAResource)
                resourceFactory_.createResource(J2EEResource.JDBC_XA_RESOURCE,
                                                name);
        
            xaDriverResources.put(xaJndiName, jdbcXAResource);
            resources.addResource(jdbcXAResource);

            xaDriverCount++;
        }

        for(int driverIndex = 0; driverIndex < xaDriverCount; driverIndex++) {
            String propPrefix = OLD_XA_DATASOURCE_PREFIX + KEY_DELIMITER +
                driverIndex + KEY_DELIMITER;
            String xaJndiName = defaultProps.getProperty
                (propPrefix + OLD_XA_JNDI_NAME);
            
            JdbcXAResource jdbcXAResource = (JdbcXAResource)
                xaDriverResources.get(xaJndiName);
            
            String className = defaultProps.getProperty
                (propPrefix + OLD_XA_CLASSNAME);
            String dbuser = defaultProps.getProperty
                (propPrefix + OLD_XA_DB_USER);
            String dbPassword = defaultProps.getProperty
                (propPrefix + OLD_XA_DB_PASSWORD);

            jdbcXAResource.setClassname(className);
            //jdbcXAResource.setDbuser(dbuser);
            //jdbcXAResource.setDbpassword(dbPassword);
            
            setJdbcXAProps(defaultProps, jdbcXAResource, driverIndex);

            if( debug ) {
                /** IASRI 4660742
                System.out.println("Adding " + jdbcXAResource); 
                **/
	   	          // START OF IASRI 4660742
                if (_logger.isLoggable(Level.FINE))
	   	              _logger.log(Level.FINE,"Adding " + jdbcXAResource);
	   	          // END OF IASRI 4660742
            }
        }
    }

    private void setJdbcXAProps(Properties defaultProps,
                                JdbcXAResource resource,
                                int index) {
        Set propSet = defaultProps.entrySet();
        String keyPrefix = OLD_XA_DATASOURCE_PREFIX + KEY_DELIMITER +
            index + KEY_DELIMITER + OLD_PROP_INDICATOR + KEY_DELIMITER;

        for(Iterator iter = propSet.iterator(); iter.hasNext(); ) {
            Map.Entry next = (Map.Entry) iter.next();
            String key = (String) next.getKey();
            String value = (String) next.getValue();
            
            if( key.startsWith(keyPrefix) ) {
                int propNameIndex = key.lastIndexOf(KEY_DELIMITER);
                String propName = key.substring(propNameIndex + 1);
                ResourceProperty rs = 
                    new ResourcePropertyImpl(propName, value);
                resource.addProperty(rs);
            }
        }
    }

}
