/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

import com.sun.enterprise.util.SystemPropertyConstants;


public class SystemLogHandler extends Handler {
    public native void logMessage(String fileName, String level, 
        String message);

    private static final String SYSLOG_FILE_PREFIX = "SJSAS81";

    // We set the prefix first and then build the complete file
    // name in the constructor.
    private String syslogFileName = SYSLOG_FILE_PREFIX;

    public SystemLogHandler( ) {
        try {
            System.loadLibrary( "utilforsyslog" );
            // We will build the syslogFileName which will be in the format
            // SJSAS81_<ClusterId>_<ServerId>.log
            // This will let users to configure Syslog to send out all 
            // AppServer Logs running on different instances to log to
            // one central server, similarly can do the same at the
            // cluster level as well.
            String serverName = System.getProperty( 
                SystemPropertyConstants.SERVER_NAME );
            String clusterId = System.getProperty(
                SystemPropertyConstants.CLUSTER_NAME );
            if( clusterId != null ) {
                syslogFileName = syslogFileName + "_" + clusterId;
            }
            if( serverName != null ) {
                syslogFileName = syslogFileName + "_" + serverName;
            } 
            syslogFileName = syslogFileName + ".log";
        } catch( Exception e ) {
            System.err.println( "Exception in loading Syslog Library..." + e );
            e.printStackTrace( );
        }
    }

    public synchronized void publish( LogRecord record ) {
        logMessage( syslogFileName, record.getLevel().toString(),
            getFormatter().format( record ) );
    }

    public void close( ) { }

    public void flush( ) { }
}

 
    
