/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.event;

import com.sun.enterprise.deployment.Application;

/**
 *
 * ApplicationClientEvents are sent before/after an application client
 *  is loaded/unloaded.
 *
 * Listeners that are interested in getting ApplicationClientLaoderEvents
 *  can register with the ApplicationClientLoaderEventNotifier as follows:
 *
 *  ApplicationClientLoaderEventNotifier notifier =
 *	ApplicationClientLoaderEventNotifier.getInstance();
 *  notifier.addListener(listener);
 *
 * Application client events are sent even when app client modules are
 *  deployed / undeployed. 
 *
 * Generally, APPLICATION events are sent in the following order
 *  a) BEFORE_APPLICATION_CLIENT_LOAD
 *  b) AFTER_APPLICATION_CLIENT_LOAD
 *  c) BEFORE_APPLICATION_CLIENT_UNLOAD
 *  d) AFTER_APPLICATION_CLIENT_UNLOAD
 *  
 *Note that this class is basically a copy of the ApplicationEvent class, with
 *the key difference being the prefix assinged for the toString method.
 *
 *Also, this class defines a parallel set of constants named for application client
 *load and unload events for clarity in logic elsewhere that uses them.
 */
public class ApplicationClientEvent extends ApplicationEvent {

    /**
     *The following constants allow listeners for this type of event to
     *use names that reflect the client-related event types, even though they
     *convey essentially the same meaning as the application-related event types.
     */
    public static final int BEFORE_APPLICATION_CLIENT_LOAD = BEFORE_APPLICATION_LOAD;
    public static final int AFTER_APPLICATION_CLIENT_LOAD = AFTER_APPLICATION_LOAD;
    public static final int BEFORE_APPLICATION_CLIENT_UNLOAD = BEFORE_APPLICATION_UNLOAD;
    public static final int AFTER_APPLICATION_CLIENT_UNLOAD = AFTER_APPLICATION_UNLOAD;

    public ApplicationClientEvent(int eventType, Application application,
	    ClassLoader loader)
    {
	super(eventType, application, loader);
    }
    
    public String toString() {
        return toString(new StringBuffer("AppClientEvent: "));
    }

}
