/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.ShutdownEventListener;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.server.PEMain;
import com.sun.enterprise.server.J2EEServer;
import com.sun.appserv.server.ServerLifecycleException;

//i18n import
import com.sun.enterprise.util.i18n.StringManager;

import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;

/**
 * Listener to handle shutdown event. 
 */

public class Shutdown implements ShutdownEventListener {

    /** logger for this manager */
    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);

    /**
     * Start shutdown on this instance.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void startShutdown(ShutdownEvent event)
            throws AdminEventListenerException {
	
	try {
		PEMain.getApplicationServer().onShutdown();
		PEMain.getApplicationServer().onTermination();
		
	} catch (ServerLifecycleException e) {
	    _logger.log(Level.SEVERE,"shutdown.error",e.getMessage());
	}

    AuditManager auditManager =
        AuditManagerFactory.getAuditManagerInstance();

    if (auditManager.isAuditOn()){
        auditManager.serverShutdown();
    }

	J2EEServer.shutdown();
	_logger.log(Level.FINE, "finished calling J2EEServer.clientShutdown()..");

    }



}
