/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AbstractSecurityManagerFactory.java
 *
 * Created on June 9, 2003, 1:44 PM
 */

package com.sun.enterprise.security.factory;

import java.util.Map;
import java.util.HashMap;

import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.deployment.Descriptor;
import java.util.logging.*; 
import com.sun.logging.LogDomains;
/**
 * This class is the parent for Web/Ejb SecurityManager. It keeps a pool of SM
 * objects.
 * @author  Harpreet Singh
 */
public abstract class AbstractSecurityManagerFactory 
    implements SecurityManagerFactory {
    
    protected static Logger _logger = 
	Logger.getLogger(LogDomains.SECURITY_LOGGER);
  
    protected static SecurityManagerFactory _theFactory = null;
    protected Map _securityManagerPool = new HashMap();
    
    public abstract SecurityManager getSecurityManager(String contextId);
    
    public abstract SecurityManager createSecurityManager(Descriptor descriptor);

    /**
     * Does the SM pool has this SM already
     * @param String the context Id of the SecurityManager
     * @return true, if SM present, false otherwise
     */
    protected boolean _poolHas(String contextId){
       return _securityManagerPool.containsKey(contextId);
    }
    
    protected void _poolPut(String contextId, SecurityManager smf){
        synchronized(_securityManagerPool){
            _securityManagerPool.put(contextId, smf);   
        }
    }
    protected SecurityManager _poolGet(String contextId){
        return (SecurityManager)_securityManagerPool.get(contextId);
    }
    
   public void removeSecurityManager(String contextId){
        synchronized (_securityManagerPool){
            _securityManagerPool.remove(contextId);
        }
    }   
}
