/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.auth.login;

import java.util.*;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;

import com.sun.enterprise.security.auth.realm.solaris.SolarisRealm;

// limit RI imports
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.PrivilegeImpl;

import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import javax.security.auth.login.LoginException;

/**
 * Solaris realm login module.
 *
 * <P>Processing is delegated to the SolarisRealm class which accesses
 * the native methods.
 *
 * @see com.sun.enterprise.security.auth.login.PasswordLoginModule
 * @see com.sun.enterprise.security.auth.realm.solaris.SolarisRealm
 *
 */
public class SolarisLoginModule extends PasswordLoginModule
{

    /**
     * Perform solaris authentication. Delegates to SolarisRealm.
     *
     * @throws LoginException If login fails (JAAS login() behavior).
     *
     */
    protected void authenticate()
        throws LoginException
    {
        if (!(_currentRealm instanceof SolarisRealm)) {
            String msg = sm.getString("solarislm.badrealm");
            throw new LoginException(msg);
        }
        
        SolarisRealm solarisRealm = (SolarisRealm)_currentRealm;

        // A solaris user must have a name not null so check here.
        if ( (_username == null) || (_username.length() == 0) ) {
            String msg = sm.getString("solarislm.nulluser");
            throw new LoginException(msg);
        }
        
        String[] grpList = solarisRealm.authenticate(_username, _password);

        if (grpList == null) {  // JAAS behavior
            String msg = sm.getString("solarislm.loginfail", _username);
            throw new LoginException(msg);
        }

        _logger.finest("Solaris login succeeded for: " + _username);

        //make a copy of groupList to pass to LoginModule. This copy is the one
        // that will be made null there. DO NOT PASS the grpList as is - as 
        // it will get overwritten. Resulting in logins passing only once.
        String[] groupListToForward = new String[grpList.length];
        for (int i = 0; i< grpList.length; i++){
            groupListToForward[i] = grpList[i];
        }

        commitAuthentication(_username, _password,
                             _currentRealm, groupListToForward);
        solarisRealm.setGroupNames(_username, groupListToForward);
    }

}
