/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.auth;

/**
 * This class implements an AuthenticationStatus object.
 * @author Harish Prabandham
 */

public class AuthenticationStatusImpl implements AuthenticationStatus {
    private String realmName; // Name of the Realm
    private String authMethod; // Method used for Authentication.
    private String principalName; // String form of the Principal.
    private int status; // Status
    
    /**
     * This constructs a new AuthenticationStatus object.
     * @param The name of the principal
     * @param The name of the realm that authenticated the principal
     * @param The method used for authenticating the principal
     * @param The status of the authentication
     */
    public AuthenticationStatusImpl(String principalName, String authMethod,
				    String realm,
				    int status) {
	this.principalName = principalName;
	this.authMethod = authMethod;
	this.status = status;
	this.realmName = realm;
    }

    /**
     * This method returns the status of the authentication
     * @return An integer value indicating the status of the authentication
     */
    public int getStatus() {
	return status;
    }

    /** 
     * This method returns a byte array of zero length, since there's
     * no continuation data needed for passphrase based authentication.
     * @return A byte array of zero length.
     */
    public byte[] getContinuationData() {
	return new byte[0];
    }

    /** 
     * This method returns a byte array of zero length, since there's
     * no auth specific data needed for passphrase based authentication.
     * @return A byte array of zero length.
     */
    public byte[] getAuthSpecificData() {
	return new byte[0];
    }

    /** 
     * This method returns the name of realm where the authentication was
     * performed.
     * @return A java.lang.String representation of the realm.
     */
    public String getRealmName() {
	return realmName;
    }
    
    /** 
     * This method returns the "method" used to perform authentication 
     * @return A java.lang.String representation of the method used. In 
     * passphrase based authentication it returns the string "password".
     */
    public String getAuthMethod() {
	return authMethod;
    }

    /** 
     * This method returns the string representation of the principal
     * that was authenticated.
     * @return A java.lang.String representation of the Principal. 
     */
    public String getPrincipalName() {
	return principalName;
    }
}
