/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security;

import java.net.Socket;

import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;

/**
 * SSL Implementation used by Tomcat security mechanism.
 *
 * @author Jean-Francois Arcand
 */
public class NSSImplementation extends SSLImplementation {

    private NSSFactory factory;

    public NSSImplementation() throws ClassNotFoundException {
        factory = new NSSFactory();
    }


    public String getImplementationName(){
        return "NSS";
    }
    
    
    public ServerSocketFactory getServerSocketFactory()  {
        return factory.getSocketFactory();
    } 

    
    public SSLSupport getSSLSupport(Socket s) {
        return factory.getSSLSupport(s);
    }    
}
