/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.util;

import java.io.File;

import java.io.FilenameFilter;
import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import com.sun.enterprise.diagnostics.Constants;
import com.sun.enterprise.diagnostics.DiagnosticException;
/**
 * Accepted file names are ejb-jar.xml, sun-ejb-jar.xml, web.xml, sun-web.xml,
 * application.xml, sun-application.xml .
 * @author Manisha Umbarje
 */
public class DDFilter implements FilenameFilter {

    private static final String ejb_jar = "ejb-jar.xml";
    private static final String sun_ejb_jar = "sun-ejb-jar.xml";
    private static final String web = "web.xml";
    private static final String sun_web = "sun-web.xml";
    private static final String application = "application.xml";
    private static final String sun_application = "sun-application.xml";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";

    public boolean accept (File aDir, String fileName) {
            
            if (fileName.matches(ejb_jar) || 
                    fileName.matches(sun_ejb_jar) || 
                    fileName.matches(web) || 
                    fileName.matches(sun_web)||
                    fileName.matches(application) ||
                    fileName.matches(sun_application)) {
                return true;
            }
            else
                return false;
    }
}