/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.io.File;
import java.util.logging.Level;

/**
 *
 * @author mu125243
 */
public class PELocalTargetResolver extends TargetResolver {
    
    /** Creates a new instance of PELocalTargetResolver */
    public PELocalTargetResolver(String target, String repositoryDir, boolean local) {
        super(target,repositoryDir,local);
    }
    
    /**
     * Combination of targetDir and target in local mode is expected
     * to be appserver's nodeagent's or server instance's directory structure
     * @param targetDir targetDir in local mode
     * @param target target name for which report generation is initiated
     * @return true if directory structure seems inline with nodeagent / instance
     * directory structure
     * @throw DiagnosticException if targetDir and target are null
     */
    public boolean validateTarget() throws DiagnosticException {
        if(repositoryDir != null && target != null){
            logger.log(Level.FINEST, "validate_local_target" , new String[]{target, repositoryDir});
            return isAInstance(repositoryDir,target);
        } // if
        throw new DiagnosticException("Targetdir and targetname are null");
    }
    
    private boolean isAInstance(String repositoryDir, String target) {
        if(repositoryDir != null && target != null){
            String absoluteDir = repositoryDir + File.separator + target;
            File applicationsDirObj = new File(absoluteDir +
                    Constants.APPLICATIONS_DIR);
            File generatedDirObj = new File(absoluteDir +
                    Constants.GENERATED_DIR);
            File configDirObj = new File(absoluteDir +
                    Constants.CONFIG_DIR);
            if(applicationsDirObj.exists() &&
                    generatedDirObj.exists() &&
                    configDirObj.exists())
                return true;
            return false;
        }//if
        return false;
    }
    
    protected  void determineRepositoryDetails() {
        repositoryName = target;
    }

    protected void setExecutionContext() {
        context = ExecutionContext.LOCAL_EC;
    
    }
    
    protected void determineTargetType() {
        if(type == null)
            setTargetType(TargetType.DAS);
    }
    
    protected void determineTargetDir() {
        //do nothing
    }
    
    protected void determineInstances(){
        addInstance(TargetType.DAS.getType());
    }

}
