/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.util.zip.ZipFile;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Manisha Umbarje
 */
public interface DiagnosticAgent {
    /**
     * Generates Diagnostic Report
     * @param clioptions cli options specified by the user
     * @return zip containing diagnostic report
     * @throw DiagnosticException 
     */
    public String generateReport(Map clioptions) throws DiagnosticException ;
    
    /**
     * Generates Diagnostic Report
     * @param clioptions cli options specified by the user
     * @instances list of instance names for which report generation is invoked
     * @targetType type of the target for which report is being generated
     * @return zip containing diagnostic report
     * @throw DiagnosticException 
     */
    public String generateReport(Map clioptions, List<String> instances,
            String targetType) throws DiagnosticException ;
    
    /**
     * @param repositoryDir absolute path of central repository
     * @return list of attributes being masked with ****
     * @throw DiagnosticException 
     */
    public List<String> getConfidentialProperties(String repositoryDir) 
    throws DiagnosticException;
    
    
    /**
     * Deletes report specified by the file
     * @param file File to be deleted.
     * @throws DiagnosticException
     */
    public void deleteReport(String file) throws DiagnosticException;
                  
}
