/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentTarget.java
 *
 * Created on May 23, 2003, 3:47 PM
 * @author  sandhyae
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/phasing/DeploymentTarget.java,v $
 *
 */

package com.sun.enterprise.deployment.phasing;

import javax.enterprise.deploy.spi.Target;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.backend.DeployableObjectType;

/**
 * Abstract class extended by ServerDeploymentTarget, GroupDeploymentTarget
 * @author Sandhya E
 */
public interface DeploymentTarget extends Target{

    /**
     * Returns the list of modules of specified type and specified status. 
     * If enabled = true, all enabled modules of specified type are returned
     * If enabled = false, all disabled modules of type are returned
     * If enabled = null, all modules are returned
     * @param type module type DeployableObjectType
     * @param enabled status of module that have to be returned
     */
    public abstract String[] getModules(DeployableObjectType type, Boolean enabled) 
        throws DeploymentTargetException;
    
    /**
     * Adds a reference to this application in server
     * @param appName name of the application
     * @param enabled if true application is marked as enabled
     */
    public abstract void addAppReference(String appName, boolean enabled, String virtualServers) throws DeploymentTargetException;
    
    /**
     * Removes a reference to this app from the target
     * @param appName name of the application
     */
    public abstract void removeAppReference(String appName) throws DeploymentTargetException;
    
    /**
     * sends applicaiton/module start stop events to the target server.
     * @param eventType 
     * @param appName name of the application/module
     * @param moduleType ["ejb"/"web"/"connector"]
     */
    public abstract boolean sendStartEvent(int eventType, String appName, String moduleType) throws DeploymentTargetException;

    /**
     * sends applicaiton/module start stop events to the target server.
     * @param eventType
     * @param appName name of the application/module
     * @param moduleType ["ejb"/"web"/"connector"]
     * @param isForced indicates if the deployment is forced
     */
    public abstract boolean sendStartEvent(int eventType, String appName, 
           String moduleType, boolean isForced) throws DeploymentTargetException;

    public abstract boolean sendStartEvent(int eventType, String appName,
           String moduleType, boolean isForced, int loadUnloadAction) throws DeploymentTargetException;

    public abstract boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade) throws DeploymentTargetException;

    public abstract boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force) throws DeploymentTargetException;

    public abstract boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force, int loadUnloadAction) throws DeploymentTargetException;

    public abstract com.sun.enterprise.admin.target.Target getTarget();
        
}
