/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client;

import javax.enterprise.deploy.spi.Target;

/**
 * This class reprensents a deployment target
 *
 * @author Jerome Dochez
 */
public class JESTarget implements Target {
    
    private String name;
    private String description;
        
    /** Creates a new instance of JESTarget 
     * @param name is the cluster or standalone instance 
     * identifier
     * @param optional description for deployment feedback
     * on the target
     */
    public JESTarget(String name, String description) {
        this.name = name;
        this.description = description;
    }
    
    public String getDescription() {
        return description;
    }
    
    public String getName() {
        return name;
    }    
}
