/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.backend;

/**
 * Represents the archive file layout in the repository for a 
 * deployment operation.
 * 
 * For S1AS 7.0, the only mode supported is EXPLODED.
 *
 * @author  Nazrul Islam
 * @since   JDK 1.4
 */
public class DeploymentMode { 

    /**
     * Private constructor. 
     *
     * @param    mode    mode of this deployment
     */
    private DeploymentMode(String mode) {
        assert mode != null;
        this.mode = mode;
    }

    /**
     * Retruns a string representation of this deploy mode.
     */
    public String toString() {
        return this.mode;
    }

    /** deploy mode where the archive and all the modules are exploded */
    public static final DeploymentMode EXPLODED = 
            new DeploymentMode("EXPLODED");

    /** deploy mode where the top level archive is only exploded */
    public static final DeploymentMode COMPONENT = 
            new DeploymentMode("COMPONENT");

    /** mode of this deployment */
    private final String mode;
}
