/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentEventInfo.java
 *
 * Created on April 21, 2003.
 */

package com.sun.enterprise.deployment.backend;

import java.io.File;

import com.sun.enterprise.deployment.Application;

/**
 * A <code>DeploymentEventInfo</code> is used to store all necessary
 * information for the <code>DeploymentEvent</code> event that gets delivered 
 * whenever a <code>DeploymentEventListener</code> registers itself with the 
 * <code>DeploymentEventManager</code>.
 *
 * This class does not have setXXX methods as all the values are set
 * during instance construction.
 * @author Marina Vatkina
 */
public class DeploymentEventInfo
{
    /** The directory where the archive has been exploded */
    private File srcDir;

    /** The directory where all the code is generated and being compiled */
    private File stubsDir;

    /** The directory where the previous code version was generated and compiled */
    private File oldStubsDir;

    /** The Application deployment descriptor object */
    private Application application;

    /** The deployment request object */
    private DeploymentRequest request;

    /** Constructs <code>DeploymentEventInfo</code> from all neccessary
     * elements.
     * @param srcDir the directory where the archive has been exploded.
     * @param stubsDir the directory where all the code is generated and being compiled.
     * @param application the Application deployment descriptor object for the event.
     * @param request the deployment request object.
     */
    public DeploymentEventInfo(File srcDir, File stubsDir, Application application, 
        DeploymentRequest request) {

        this.srcDir = srcDir;
        this.stubsDir = stubsDir;
        this.application = application;
        this.request = request;
        this.oldStubsDir = null;
       
    }

    /** Constructs <code>DeploymentEventInfo</code> from all neccessary
     * elements.
     * @param srcDir the directory where the archive has been exploded.
     * @param stubsDir the directory where all the code is generated and being compiled.
     * @param oldStubsDir the directory where the previous code version was generated and compiled.
     * @param application the Application deployment descriptor object for the event.
     * @param request the deployment request object.
     */
    public DeploymentEventInfo(File srcDir, File stubsDir, File oldStubsDir,
        Application application, DeploymentRequest request) {

        this.srcDir = srcDir;
        this.stubsDir = stubsDir;
        this.oldStubsDir = oldStubsDir;
        this.application = application;
        this.request = request;
       
    }
     
     /**
      * Constructs DeploymentEventInfo with request object
      * @param DeploymentRequest
      * @return DeploymentEventInfo
      */
     public DeploymentEventInfo(DeploymentRequest request) {
         this.request = request;
     }


    /** Returns the directory where the archive has been exploded.
     * @return directory where the archive has been exploded.
     */
    public File getSrcDir() {
        return srcDir;
    }

    /** Returns the directory where all the code is generated and being compiled.
     * @return directory where all the code is generated and being compiled.
     */
    public File getStubsDir() {
        return stubsDir;
    }

    /** Returns the directory where the previous code version was generated and compiled.
     * @return directory where the previous code version was generated and compiled.
     */
    public File getOldStubsDir() {
        return oldStubsDir;
    }

    /** Returns the Application deployment descriptor object.
     * @return application deployment descriptor object.
     */
    public Application getApplicationDescriptor() {
        return application;
    }

    /** Returns the deployment request object.
     * @return request the deployment request object.
     */  
    public DeploymentRequest getDeploymentRequest() {
        return request;
    }

}
