/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeployerFactory.java
 *
 * Created on December 11, 2001, 6:25 PM
 */

package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.util.i18n.StringManager;

/**
 *
 * @author  bnevins
 * @version 
 */
public class DeployerFactory 
{
	private static StringManager localStrings =
		StringManager.getManager( DeployerFactory.class );

	private DeployerFactory() 
	{
	}
	
	///////////////////////////////////////////////////////////////////////////

	public static Deployer getDeployer(DeploymentRequest request) throws IASDeploymentException
	{
		assert request != null;
		request.verify();
		
		if(request.isApplication())
			return getAppDeployer(request);
		else if(request.isEjbModule())
			return new EjbModuleDeployer(request);
		else if(request.isWebModule())
			return new WebModuleDeployer(request);
		else if(request.isConnectorModule())
			return new ConnectorModuleDeployer(request);
		else if (request.isAppClientModule())
		{
			if(request.isDirectory())
			{
				String msg = localStrings.getStringWithDefault
				(
					"enterprise.deployment.backend.DirDeployOfAppClient",
					"App Client Directory-Deployment not supported"
				);
				throw new IASDeploymentException(msg);
			}
			else
				return new AppClientModuleDeployer(request);	
		}
		else {
			String msg = localStrings.getString(
					"enterprise.deployment.backend.deployment_not_supported" );
			throw new IASDeploymentException( msg );
		}
	}
	
	///////////////////////////////////////////////////////////////////////////

	public static Deployer getAppDeployer(DeploymentRequest request) throws IASDeploymentException
	{
		if(request.isDeploy())
		{
			return new AppDeployer(request);
		}
		else if(request.isReDeploy())
		{
			return new AppReDeployer(request);
		}
		else if(request.isUnDeploy())
		{
			return new AppUnDeployer(request);
		}
		else {
			String msg = localStrings.getString(
            "enterprise.deployment.backend.unknown_deployment_request_type" );
			throw new IASDeploymentException( msg );
		}
	}
}
