/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployapi;


import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ActionType;
/**
 *
 * @author  dochez
 */
public class DeploymentStatusImpl implements DeploymentStatus {
    
    ProgressObjectImpl progressObject;
    StateType stateType = null;
    String lastMsg = null;
    CommandType commandType = null;
    
    /** Creates a new instance of DeploymentStatusImpl */
    public DeploymentStatusImpl(ProgressObjectImpl progressObject) {
        this.progressObject = progressObject;
    }

    public DeploymentStatusImpl() {
    }
    
    /** Retrieve the deployment ActionType for this event.
     *
     * @return the ActionType Object
     */
    public ActionType getAction() {
        return ActionType.EXECUTE;
    }
    
    /** Retrieve the deployment CommandType of this event.
     *
     * @return the CommandType Object
     */
    public CommandType getCommand() {
        if (progressObject!=null) {
            return progressObject.getCommandType();
        } else {
            return commandType;
        }
    }
    
    /** Retrieve any additional information about the
     * status of this event.
     *
     * @return message text
     */
    public String getMessage() {
        return lastMsg;
    }
    
    /** Retrieve the StateType value.
     *
     * @return the StateType object
     */
    public StateType getState() {
        return stateType;
    }
    
    /** A convience method to report if the operation is
     * in the completed state.
     *
     * @return true if this command has completed successfully
     */
    public boolean isCompleted() {
        return StateType.COMPLETED.equals(stateType);        
    }
    
    /** A convience method to report if the operation is
     * in the failed state.
     *
     * @return true if this command has failed
     */
    public boolean isFailed() {
        return StateType.FAILED.equals(stateType);        
    }
    
    /** A convience method to report if the operation is
     * in the running state.
     *
     * @return true if this command is still running
     */
    public boolean isRunning() {
        return StateType.RUNNING.equals(stateType);
    }
    
    public void setState(StateType stateType) {
        this.stateType = stateType;
    }
    
    public void setMessage(String message) {
        lastMsg = message;
    }
    
    public void setCommand(CommandType commandType) {
        this.commandType = commandType;
    }
}
