/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.enterprise.admin.verifier.tests;

/*  Test case to check the validity of Lifecycle module fields
 *  Author : srini@sun.com
 */

import java.net.*;

// 8.0 XML Verifier
//import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.ConfigContextEvent;

import com.sun.enterprise.admin.verifier.*;
// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;



public class LifecycleModuleTest extends ServerXmlTest implements ServerCheck {
    // Logging
    static Logger _logger = LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    
    public LifecycleModuleTest() {
    }
 
    // check method invoked by the command line verifier
    public Result check(ConfigContext context) {
                Result result;
                result = super.getInitializedResult();
                // 8.0 XML Verifier
                /*try {
                    Server server = (Server)context.getRootConfigBean();
                    Applications app = server.getApplications();
                    LifecycleModule[] life = app.getLifecycleModule();
                    String loadOrder=null;
                    for(int i=0;i<life.length;i++){
                        try {
                           loadOrder=life[i].getLoadOrder();
                           if(loadOrder!=null) {
                                // Bug 4711204
                                if(Integer.parseInt(loadOrder) < 0)
                                    result.failed("Load Order Must be positive number");
                           }
                        }
                        catch(NumberFormatException e) {
                           result.failed("Load Order " + loadOrder + " for LifeCycleModule " + life[i].getName() + " :  must be integer value : Failed" );
                        }
                    }
                    result.passed("Test Passed : ");
                }
                catch(Exception ex){
                    //<addition author="irfan@sun.com" [bug/rfe]-id="logging" >
                    //result.failed("Test Failed **** ");
                    _logger.log(Level.FINE, "serverxmlverifier.exception", ex);
                    result.failed("Exception : " + ex.getMessage());
                    //</addition>
                }*/
                return result;
    }
    
    // check method called from the admin GUI and iasadmin
    public Result check(ConfigContextEvent ccce) {
                Object value = ccce.getObject();
                Result result = new Result();
                String beanName = ccce.getBeanName();
                if(beanName!=null) {
				    String name = ccce.getName();
				    return testSave(name,(String)value);
                }
                LifecycleModule life = (LifecycleModule)value;
                
                // check if Lifecycle Module name  is valid object name Bug : 4698687 : start
                String id = life.getName();
                if(StaticTest.checkObjectName(id, result)) 
                    result.passed("Valid Object Name");
                else {
                    result.failed("LifeCycle Module Name Invalid ");
                    return result;
                }
                // End Bug : 4698687
                
                String loadOrder = life.getLoadOrder();
                
                try {
                    //load-order is optional.
                    // If loadOrder is null, load-order does not exist. so we are okay.
                    if(loadOrder!=null) {
                        // Bug : 4711204
                        if(Integer.parseInt(loadOrder) < 0)  {
                            result.failed("Load Order Must be positive number");
                            return result;
                        }
                    }
                    result.passed("Test passed ******");
                }
                catch(NumberFormatException e) {
                    result.failed("Load Order for LifeCycleModule must be integer value");
                }
                return result;
    }    
    
    public Result testSave(String name, String value) {
	    Result result = new Result();
            result.passed(" ***");
   	    if(name.equals("load-order")){
                try {
                    if(value!=null) {
                        // Bug : 4711204
                        if(Integer.parseInt(value) < 0) {
                            result.failed("Load Order Must be positive number");
                            return result;
                        }
                    }
                    result.passed("Test passed ******");
                }catch(NumberFormatException e) {
                    result.failed("Load Order for LifeCycleModule must be integer value");
                }   
	    }
            return result;
    }
}
