/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.enterprise.admin.verifier.tests;

/**
 * Test case to check the validity of the JavaConfig fields
 *
 * @author  Venky TV
 * @version $Revision: 1.3 $
 */


import java.io.File;

// 8.0 XML Verifier
//import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Applications;
//import com.sun.enterprise.config.serverbeans.Mime;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.ConfigContextEvent;

import com.sun.enterprise.admin.verifier.*;
// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

public class JavaConfigTest extends ServerXmlTest implements ServerCheck {
    
     // Logging
    static Logger _logger = LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    
    public JavaConfigTest() {
    }

    // check method invoked by the command line verifier
    // Does nothing right now
    public Result check(ConfigContext context) {
            Result result;
            result = super.getInitializedResult();
            return result;
    }

    // check method called from the admin GUI and iasadmin
    public Result check(ConfigContextEvent ccce) {
        Object value = ccce.getObject();
        ConfigContext context = ccce.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String beanName = ccce.getBeanName();
        if(beanName!=null) {
            String name = ccce.getName();
            result = validateAttribute(name, (String)value);
        }
        return result;
    }

    public Result validateAttribute(String name, String value) {
        Result result = new Result();
        result.passed("Passed **");

        if( name != null && name.equals( ServerTags.JAVA_HOME ) ) {

            if( value == null ) {
                result.failed( "Java Home value is null" );
                return( result );
            }

            /* Check if <java-home>/jre is a valid directory */
            String jreDir = value + File.separator + "jre";
            try {
                File f = new File( jreDir );
                if( ! f.isDirectory() ) {
                    result.failed( "Invalid Java Home: "
                            + "Could not find the jre directory under "
                            + value  );
                    return( result );
                }
            }
            catch( Exception e ) {
                result.failed( e.getMessage() );
                return( result );
            }

        }
        return( result );
    }
}
