/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LogNotificationFilter.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.NotificationFilter;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import com.sun.appserv.management.ext.logging.*;
import com.sun.appserv.management.base.Util;
import com.sun.enterprise.util.i18n.StringManager;

/**
 *
 * This is a NotificationFilter that will be instrumented to LogEvent to
 * filterout unwanted logEvents. Basically, it will filterout logs based on
 * LoggerName and Level settings.
 *
 * @author Sun Micro Systems, Inc
 */
public class LogEventFilter implements NotificationFilter {
    private static StringManager sm = StringManager.getManager(LogEventFilter.class);
    private boolean anyLogger = false;
    
    private ArrayList<String> loggerNames;
    
    private Level level;
    
    /** Creates a new instance of LogNotificationFilter */
    public LogEventFilter() {
    }
    
    public List getLoggerNames() {
        return loggerNames;
    }
    
    public void setLoggerNames(String loggers) {
        if( loggers == null ){
            return;
        }
        loggerNames = new ArrayList<String>( );
        StringTokenizer tokenizer = new StringTokenizer(loggers, ",");
        while( tokenizer.hasMoreTokens()) {
            String loggerName = tokenizer.nextToken();
            if ("*".equals(loggerName)) {
                anyLogger = true;
                loggerNames.add( loggerName );
                return;
            }
            loggerNames.add( loggerName );
        }
    }
    
    public String getLevel() {
        return level.toString();
    }
    
    public void setLevel(String level) {
        this.level = Level.parse(level);
    }
    
    // IMPORTANT: Do not put any logging statements in this method
    // This would cause infinite loop as the log statements would
    // generate another notification
    // Not even System.out or System.err
    
    public boolean isNotificationEnabled(
            javax.management.Notification notification ) {
        boolean loggerNameMatched = false;
        boolean logLevelMatched = false;
        
        if (anyLogger)
            loggerNameMatched = true;
        else {
            String loggerNameFromNotification = (String)Util.getAMXNotificationValue(notification,
                    LogRecordEmitter.LOG_RECORD_LOGGER_NAME_KEY);
            Iterator iterator = loggerNames.iterator( );
            while( iterator.hasNext( ) ) {
                String loggerNameFromList = (String) iterator.next( );
                if( loggerNameFromNotification.startsWith( loggerNameFromList )) {
                    loggerNameMatched = true;
                    break;
                }
            }
        }
        Level logLevelFromNotification = (Level)Util.getAMXNotificationValue(notification,
                LogRecordEmitter.LOG_RECORD_LEVEL_KEY);
        if( logLevelFromNotification.intValue() >= this.level.intValue() ) {
            logLevelMatched = true;
        }
        return loggerNameMatched && logLevelMatched;
    }
    
    
}
