/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

/**
 * List command for monitoring. 
 */
public class MonitorListCommand extends MonitorCommand {

    /**
     * Constant to denote - List types of available MBeans
     */
    private static final int LIST_TYPE = 1;

    /**
     * Constant to denote - List available MBean names.
     */
    private static final int LIST_INSTANCE = 3;

    /**
     * Constant to denote - List available MBean types and names.
     */
    private static final int LIST_TYPE_AND_INSTANCE = 5;

    /**
     * Create a MonitorListCommand to list available MBean types and names. This
     * command will produce a list of all child MBeans in the form type.name.
     * @param mbeanName object name of the MBean
     */
    MonitorListCommand(ObjectName mbeanName) {
        this.objectName = mbeanName;
        this.actionCode = LIST_TYPE_AND_INSTANCE;
    }

    /**
     * Create a MonitorListCommand to list available MBean names. This command
     * will produce a list of names of all child MBeans of specified type.
     * @param mbeanName object name of the MBean
     * @param type type of the child MBeans
     */
    MonitorListCommand(ObjectName mbeanName, MonitoredObjectType type) {
        this.objectName = mbeanName;
        this.actionCode = LIST_INSTANCE;
        this.monitoredObjectType = type.getTypeName();
    }

    /**
     * Run the command to produce a list. The method returns a String[] of
     * length 0 or more.
     * @throws InstanceNotFoundException if the MBean is not found.
     */
    Object runCommand() throws InstanceNotFoundException {
        BaseMonitorMBean mbean = MonitoringHelper.getMonitorMBean(objectName);
        ArrayList childList = null;
        if (actionCode == LIST_INSTANCE) {
            childList = mbean.getChildList(
                    MonitoredObjectType.getMonitoredObjectType(monitoredObjectType));
        } else {
            childList = mbean.getChildList();
        }
        String[] result = new String[childList.size()];
        Iterator iter = childList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            BaseMonitorMBean child = (BaseMonitorMBean)iter.next();
            MonitoredObjectType childType =
                    MonitoredObjectType.getMonitoredObjectType(child.getNodeType());
            if (actionCode == LIST_INSTANCE) {
                result[i] = child.getNodeName();
            } else {
                if (childType.isSingleton()) {
                    result[i] = child.getNodeType();
                } else {
                    result[i] = child.getNodeType() + "." + child.getNodeName();
                }
            }
            i++;
        }
        return result;
    }

}
