/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;


/**
 * Listener interface to handle HTTP service Http Listener events.
 *
 * @author: Satish Viswanatham
 */
public interface HSHttpListenerEventListener extends AdminEventListener {

    /**
     * Handles notification for http-service/http-listener removal.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleDelete(HSHttpListenerEvent event)
             throws AdminEventListenerException;

    /**
     * Handles notification for http-service/http-listener modification.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleUpdate(HSHttpListenerEvent event)
             throws AdminEventListenerException;

    /**
     * Handles notification for http-service/http-listener addition.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleCreate(HSHttpListenerEvent event)
             throws AdminEventListenerException;


}
