/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.domains.registry;

import java.io.IOException;


import java.lang.ClassNotFoundException;


import java.io.File;


class PersistentStore implements LockingStore
{

  PersistentStore(){
	state = new Unlocked(this);
  }
  
  public long lastModified(){
	return getStore().lastModified();
  }

  public Object readObject()  throws IOException, TimeoutException, ClassNotFoundException{
	return state.readObject();
  }

  public void writeObject(Object o)  throws IOException, TimeoutException, IllegalStateException{
	state.writeObject(o);
  }

  public void lock()  throws IOException, TimeoutException{
	state.lock();
  }

  public void unlock(){
	state.unlock();
  }

  void setState(LockingStore s){
	state = s;
  }

  LockingStore getState(){
	return state;
  }

  protected void finalize(){
	state.unlock();
  }
  
  File getLock() {
	return LOCK;
  }
  
  File getStore(){
	return STORE;
  }
	  // Location of the underlying storage
  private static File STORE;
  private static File LOCK;

  {
	STORE = new File(System.getProperty(CONFIG_ROOT), STORE_NAME);
	LOCK = new File(System.getProperty(CONFIG_ROOT), LOCK_NAME);
  }
  
  private LockingStore state;

  public static final String CONFIG_ROOT = "com.sun.aas.configRoot";
  public static final String STORE_NAME = "domains.bin";
  public static final String LOCK_NAME = "domains.lck";
  
}

	
