/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import java.util.Iterator;

import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.StringValidator;


import com.sun.enterprise.repository.ResourceProperty;
/**
    A class representing the <code> information </code> about a JCA resource adapter.

   @author  Ari Shapiro
    @version  1.0
*/

public class ResourceAdapterInfo implements Serializable {
  /**the JNDI name of the resource adapter*/
  private String	jndiName;
  /**the attributes of the resource adapter*/
  private Properties	attrs;

  /**these are the iAS specific attributes*/
  private static final String DEBUG_LEVEL = "debugLevel";
  private static final String MAX_POOL_SIZE = "maxPoolSize";
  private static final String STEADY_POOL_SIZE = "steadyPoolSize";
  private static final String MAX_WAIT = "maxWait";
  private static final String UNUSED_MAX_LIFE = "unusedMaxLife";
    
  public ResourceAdapterInfo (String jndiName) {    
  }
   
   
   private void convertAdapterProps(Set props) {
     if (props != null) {
       Iterator itr = props.iterator();
       while (itr.hasNext()) {
         ResourceProperty prop = (ResourceProperty)itr.next();
         attrs.setProperty(prop.getName(),prop.getValue().toString());
       }
     }
   }
   public String getJndiName()  {
      return jndiName;
   }


   public Properties getAttrs()  {
     return attrs;
   }

   public String toString() {
     return jndiName + " " + attrs;   
   }
}
