/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.io.Serializable;
import java.util.Properties;

import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.StringValidator;

/**
    A class representing the <code> information </code> on one JMS object.

   @author  Isa Hashim
    @version  1.0
*/

public class JMSObjectInfo implements Serializable
{
    private String	jndiName,
			type;
    private Properties	attrs;

    public JMSObjectInfo (String jndiName, String type)
    {
        ArgChecker.checkValid(jndiName, "jndiName", 
                              StringValidator.getInstance()); //noi18n
        ArgChecker.checkValid(type, "type", 
                              StringValidator.getInstance()); //noi18n

        this.jndiName = jndiName;
        this.type = type;
        this.attrs = new Properties();
    }

    public JMSObjectInfo (String jndiName, String type, Properties attrs)
    {
        this(jndiName, type);
        ArgChecker.checkValid(attrs, "attrs"); //noi18n
        this.attrs = attrs;
    }

    public String getJndiName()  {
        return (jndiName);
    }

    public String getType()  {
        return (type);
    }

    public Properties getAttrs()  {
        return (attrs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(jndiName);
        sb.append(' ');
        sb.append(type);
        sb.append(' ');
        sb.append(attrs);
        return sb.toString();
    }
}