/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
	Copyright 2000 iPlanet Alliance
*/

package com.sun.enterprise.admin.comm;

//JDK imports
import java.io.Serializable;


/**
	Represents a connection which can transfer objects through some communications channel.
	
	Also supports closing the communications channel.  Opening the
	channel is specific enough to be left to implementors.
*/

public interface IConnection
{
	/**
		Read an incoming Object.
	*/
	public Object receive() throws Exception;
	
	/**
		Write an object to the connection
	*/
	public void send( Serializable object ) throws Exception;
	
        /**
            Closes the connection.
        */
	public void close() throws Exception;
	
}

