/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise;

import java.rmi.*;

import com.sun.ejb.Container;


/**
 * The ProtocolManager interface specifies the functionality of the
 * remote communication layer, which provides the support for
 * distribution described in Chapter 13 of the EJB spec.
 * Possible implementations of the ProtocolManager include RMI/IIOP,
 * RMI/JRMP, RMI/DCOM, RMI/HTTP ....
 * @author Vivek Nagar
 */
public interface ProtocolManager {

    /**
     * Return a factory that can be used to create/destroy remote
     * references for a particular EJB type.
     */
    RemoteReferenceFactory getRemoteReferenceFactory(Container container,
                                                     boolean remoteHomeView,
                                                     String id);


    /**
     * Return true if the two object references refer to the same
     * remote object.
     */
    boolean isIdentical(Remote obj1, Remote obj2);

    /**
     * Check that all Remote interfaces implemented by target object
     * conform to the rules for valid RMI-IIOP interfaces.  Throws
     * runtime exception if validation fails.  
     */
    void validateTargetObjectInterfaces(Remote targetObj);

    /**
     * Map the RMI exception to a protocol-specific (e.g. CORBA) exception
     */
    Throwable mapException(Throwable exception);


    /**
     * Connect the RMI object to the protocol.
     */
    void connectObject(Remote remoteObj) throws RemoteException;



    /* All these APIs are used by J2EEServer at startup *****************/
    /* Not used any more - DHIRU
    public void setPersistentServerId(int id);
    public void setPersistentServerPort(int port);
    public void initTransactionService(String jtsclass) ;
    */
    public void initializeNaming(java.io.File dbDir, int orbInitialPort) throws Exception;
    /***********************************************************************
    public void setDaemonPort(int port);
    public void setLocator(com.sun.enterprise.activation.Locator locator);
    public int getListenerPort(String type) ;
    /***********************************************************************/

}
    

