/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.sfsb.util;

/**
 *
 * An instance of this class will be used by the Stateful SessionBean 
 *  Container to create sessionIDs whenever home.create(..) is called
 *
 * @author Mahesh Kannan
 */
public interface SFSBUUIDUtil {
    
   /**
    * Create and return the sessionKey.
    * @return the sessionKey object
    */
    public Object createSessionKey();
    
   /**
    * Called from the Container before publishing an IOR. The method must convert the sessionKey into a byte[]
    * @return A byte[] representation of the key. The byte[] could be created using serialization.
    */
    public byte[] keyToByteArray(Object sessionKey);
    
    /**
     * Return the sessionKey that represents the sessionKey. This has to be super efficient as the container
     *    calls this method on every invocation. Two objects obtained from identical byte[] must
     *    satisfy both o1.equals(o2) and o1.hashCode() == o2.hashCode()
     * @return the sessionKey object
     */
     public Object byteArrayToKey(byte[] array, int startIndex, int len);    
    
}
