/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.sfsb.store;

/**
 *
 * A Store to checkpoint bean states at the end of Tx
 *
 * @author Mahesh Kannan
 */
public interface SFSBTxStoreManager {
    
    /**
     * Store session data in these beanStates
     * This method used only for aggregate checkpointing
     * i.e. at the end of a transaction, collecting beanStates
     * from all the beans that have participated in a transaction
     * Note: if the underlying implementation involves a transactional
     * data store, then the attempt should be made to store all the 
     * bean states in a single transactional unit-of-work
     */
    public void checkpointSave(SFSBBeanState[] beanStates)
        throws SFSBStoreManagerException;    
    
}
