/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.codegen;

import java.lang.reflect.Method;
import java.io.*;
import java.util.*;
import java.util.logging.*;
import com.sun.logging.*;
import com.sun.ejb.EJBUtils;

import sun.rmi.rmic.IndentingWriter;

import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.EntityBean;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;

import static java.lang.reflect.Modifier.*;
import static com.sun.corba.ee.spi.codegen.Wrapper.*;
import com.sun.corba.ee.spi.codegen.Type;
import com.sun.corba.ee.impl.codegen.ClassGenerator;

/**
 * This class is used to generate a Serializable sub-class
 * of a 3.0 stateful session bean.
 */

public class SerializableBeanGenerator extends Generator 
    implements ClassGeneratorFactory {

    private static LocalStringManagerImpl localStrings =
	new LocalStringManagerImpl(SerializableBeanGenerator.class);
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.DPL_LOGGER);
    }

    private Class beanClass;
    private String generatedSerializableClassName;

    private ClassLoader loader;

    /**
     * Get the fully qualified name of the generated class.
     * @return the name of the generated class.
     */
    public String getGeneratedClass() {
        return generatedSerializableClassName;
    }

    // For corba codegen infrastructure
    public String className() {
        return getGeneratedClass();
    }

    public SerializableBeanGenerator(ClassLoader cl,
                                     String beanClassName) 
	throws GeneratorException 
    {
	super();

        loader = cl;
	try {
	    beanClass = cl.loadClass(beanClassName);
	} catch (ClassNotFoundException ex) {
	    throw new InvalidBean(
		localStrings.getLocalString(
		"generator.remote_interface_not_found",
		"Remote interface not found "));
	}

        generatedSerializableClassName = 
            EJBUtils.getGeneratedSerializableClassName(beanClassName);

    }

    public ClassGenerator evaluate() {

        _clear();

	String packageName = getPackageName(generatedSerializableClassName);
        String simpleName = getBaseName(generatedSerializableClassName);
        
        if( packageName != null ) {
            _package(packageName);
        } else {
            // no-arg _package() call is required for default package
            _package();
        }

        List toImplement = new LinkedList<Type>();
        toImplement.add(_t("java.io.Serializable"));
        _class(PUBLIC, simpleName, _t(beanClass.getName()), toImplement);

        _constructor( PUBLIC ) ;
        _body();
        _expr(_super(_s(_void()))) ;
        _end();

        _method( PRIVATE, _void(), "writeObject", _t("java.io.IOException"));
            _arg( _t("java.io.ObjectOutputStream"), "oos" );
        _body();
            _expr(_call( _t("com.sun.ejb.EJBUtils"), "serializeObjectFields",
                   _s(_void(), 
                      _Class(), _Object(), _t("java.io.ObjectOutputStream")),
                   _const(_t(beanClass.getName())), _this(), 
                   _v("oos")));
        _end();


        _method( PRIVATE, _void(), "readObject", _t("java.io.IOException"),
                 _t("java.lang.ClassNotFoundException") );
            _arg( _t("java.io.ObjectInputStream"), "ois" );
        _body();
            _expr(_call( _t("com.sun.ejb.EJBUtils"), "deserializeObjectFields",
                   _s(_void(), 
                      _Class(), _Object(), _t("java.io.ObjectInputStream")),
                   _const(_t(beanClass.getName())), _this(), 
                   _v("ois")));
        _end();
     
        _end();

        return _classGenerator() ;
    }

    /**
     * Generate the code to the specified output stream.
     * @param the output stream
     * @exception GeneratorException on a generation error
     * @exception IOException on an IO error
     */
    public void generate(OutputStream out)
	throws GeneratorException, IOException 
    {
	IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));

	String packageName = getPackageName(generatedSerializableClassName);
        String simpleName = getBaseName(generatedSerializableClassName);

        p.pln("");

	if (packageName != null) {
	    p.pln("package " + packageName + ";");
        }

        p.pln("");

	p.plnI("public class " + simpleName + " extends " + beanClass.getName()
               + " implements java.io.Serializable { ");

        p.pln("");

        p.plnI("private void writeObject(java.io.ObjectOutputStream oos) throws java.io.IOException {");
        p.pln("    com.sun.ejb.EJBUtils.serializeObjectFields(" +
              beanClass.getName() + ".class, this, oos);");
        p.pln("}");

        p.plnI("private void readObject(java.io.ObjectInputStream ois) throws java.io.IOException, java.lang.ClassNotFoundException {");
        p.pln("    com.sun.ejb.EJBUtils.deserializeObjectFields(" +
              beanClass.getName() + ".class, this, ois);");
        p.pln("}");

	p.pOln("}");
	p.close();
    }



}
